/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing.text;

import edu.princeton.swing.PHighlightedTextArea;
import edu.princeton.swing.text.AutoCompleter;
import edu.princeton.swing.text.HighlightedDocument;
import java.awt.event.KeyEvent;

public class IndentingAutoCompleter
implements AutoCompleter {
    @Override
    public boolean interceptKeyEvent(PHighlightedTextArea comp, KeyEvent e) {
        int selectionEndOffset;
        if (e.getKeyChar() != '\t' || e.getID() != 400) {
            return false;
        }
        int selectionStartOffset = comp.getSelectionStart();
        if (selectionStartOffset == (selectionEndOffset = comp.getSelectionEnd())) {
            return false;
        }
        HighlightedDocument document = comp.getDocument();
        int startLine = document.offsetToCoordinate((int)selectionStartOffset).y;
        int endLine = document.offsetToCoordinate((int)selectionEndOffset).y;
        if (startLine == endLine) {
            return false;
        }
        int tabSize = document.getTabSize();
        int startOffset = document.coordinateToOffset(0, startLine);
        int endOffset = document.coordinateToOffset(Integer.MAX_VALUE, endLine);
        String string = document.getText(startOffset, endOffset);
        int length = string.length();
        if (!e.isShiftDown()) {
            int ctr;
            StringBuffer buffer = new StringBuffer(endOffset - startOffset + (endLine - startLine + 1) * tabSize);
            StringBuffer tab = new StringBuffer(tabSize);
            for (ctr = 0; ctr < tabSize; ++ctr) {
                tab.append(' ');
            }
            buffer.append(tab);
            for (ctr = 0; ctr < length; ++ctr) {
                char ch = string.charAt(ctr);
                if (ch == '\n') {
                    buffer.append('\n');
                    buffer.append(tab);
                    continue;
                }
                buffer.append(ch);
            }
            document.replace(startOffset, length, buffer.toString(), false);
            comp.select(startOffset, startOffset + buffer.length(), startOffset);
        } else {
            StringBuffer buffer = new StringBuffer(endOffset - startOffset);
            int unindentCtr = tabSize;
            for (int ctr = 0; ctr < length; ++ctr) {
                char ch = string.charAt(ctr);
                if (unindentCtr > 0 && ch == ' ') {
                    --unindentCtr;
                    continue;
                }
                unindentCtr = 0;
                if (ch == '\n') {
                    buffer.append('\n');
                    unindentCtr = tabSize;
                    continue;
                }
                buffer.append(ch);
            }
            document.replace(startOffset, length, buffer.toString(), false);
            comp.select(startOffset, startOffset + buffer.length(), startOffset);
        }
        return true;
    }
}

